/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesGrave;
import com.minecolonies.api.blocks.types.GraveType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.util.InventoryUtils;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class BlockMinecoloniesGrave
extends AbstractBlockMinecoloniesGrave<BlockMinecoloniesGrave> {
    private static final float BLOCK_HARDNESS = 1.5f;
    private static final String BLOCK_NAME = "blockminecoloniesgrave";
    private static final float RESISTANCE = 5.0f;
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public BlockMinecoloniesGrave() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 5.0f).harvestTool(ToolType.SHOVEL).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)VARIANT, (Comparable)((Object)GraveType.DEFAULT)));
        this.setRegistryName("minecolonies".toLowerCase() + ":" + BLOCK_NAME);
    }

    public boolean func_200123_i(BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos) {
        return false;
    }

    @NotNull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = this.func_176223_P();
        TileEntity entity = worldIn.func_175625_s(pos);
        if (!(entity instanceof TileEntityGrave)) {
            return super.func_196258_a(context);
        }
        return BlockMinecoloniesGrave.getPlacementState(state, entity, pos);
    }

    public static BlockState getPlacementState(BlockState state, TileEntity entity, BlockPos pos) {
        return (BlockState)state.func_206870_a((Property)VARIANT, (Comparable)((Object)GraveType.DEFAULT));
    }

    @Deprecated
    @NotNull
    public BlockState func_185499_a(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState func_185471_a(@NotNull BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityGrave) {
            IItemHandlerModifiable handler = ((AbstractTileEntityGrave)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (World)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        super.func_220062_a(state, worldIn, pos, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if ((colony == null || colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) && tileEntity instanceof TileEntityGrave) {
            TileEntityGrave grave = (TileEntityGrave)tileEntity;
            if (!worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)grave, buf -> buf.func_179255_a(grave.func_174877_v()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState tempState = state;
        tempState = (BlockState)tempState.func_206870_a((Property)VARIANT, (Comparable)((Object)GraveType.DEFAULT));
        if (placer != null) {
            tempState = (BlockState)tempState.func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        }
        worldIn.func_180501_a(pos, tempState, 2);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, VARIANT});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityGrave();
    }

    public void func_196243_a(BlockState state, @NotNull World worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityGrave) {
                TileEntityGrave tileEntityGrave = (TileEntityGrave)tileEntity;
                InventoryUtils.dropItemHandler((IItemHandler)tileEntityGrave.getInventory(), worldIn, tileEntityGrave.func_174877_v().func_177958_n(), tileEntityGrave.func_174877_v().func_177956_o(), tileEntityGrave.func_174877_v().func_177952_p());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

